<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Admin'); ?> - Harris Absensi</title>

    <script src="https://cdn.tailwindcss.com"></script>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>


    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap');

        * {
            font-family: 'Poppins', sans-serif;
        }

        .gradient-orange {
            background: linear-gradient(135deg, #FF6B35 0%, #FF8C42 100%);
        }

        .sidebar-link {
            transition: all 0.3s ease;
        }

        .sidebar-link:hover {
            background: rgba(255, 107, 53, 0.1);
            border-left: 4px solid #FF6B35;
            padding-left: 1.5rem;
        }

        .sidebar-link.active {
            background: rgba(255, 107, 53, 0.15);
            border-left: 4px solid #FF6B35;
            padding-left: 1.5rem;
            font-weight: 600;
        }

        #sidebar {
            transition: transform 0.3s ease;
        }

        @media (max-width: 768px) {
            #sidebar.closed {
                transform: translateX(-100%);
            }
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="bg-gray-50">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <?php echo $__env->make('admin.components.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Header -->
            <?php echo $__env->make('admin.components.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- Page Content -->
            <main class="flex-1 overflow-y-auto bg-gray-50 p-4 md:p-6">
                <!-- Breadcrumb (Optional) -->
                <?php if(isset($breadcrumbs)): ?>
                <nav class="mb-4 text-sm">
                    <ol class="flex items-center space-x-2 text-gray-600">
                        <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($loop->last): ?>
                                <li class="text-orange-600 font-semibold"><?php echo e($label); ?></li>
                            <?php else: ?>
                                <li>
                                    <a href="<?php echo e($url); ?>" class="hover:text-orange-600"><?php echo e($label); ?></a>
                                    <span class="mx-2">/</span>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ol>
                </nav>
                <?php endif; ?>

                <!-- Flash Messages -->
                
        <?php echo $__env->make('notifikasi.toast', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <!-- Page Content -->
                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </div>

    <!-- Mobile Sidebar Overlay -->
    <div id="sidebar-overlay" class="hidden fixed inset-0 bg-black bg-opacity-50 z-30 md:hidden" onclick="toggleSidebar()"></div>

    <script>
        // Toggle Sidebar untuk Mobile
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');

            sidebar.classList.toggle('closed');
            overlay.classList.toggle('hidden');
        }

        // Auto close pada resize
        window.addEventListener('resize', function() {
            if (window.innerWidth >= 768) {
                document.getElementById('sidebar').classList.remove('closed');
                document.getElementById('sidebar-overlay').classList.add('hidden');
            }
        });

        function toggleUserMenu() {
    const menu = document.getElementById('userMenu');
    menu.classList.toggle('hidden');
}

// tutup dropdown saat klik di luar
document.addEventListener('click', function (e) {
    const menu = document.getElementById('userMenu');
    const button = e.target.closest('[onclick="toggleUserMenu()"]');

    if (!menu.contains(e.target) && !button) {
        menu.classList.add('hidden');
    }
});


</script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\Users\DAVA\Documents\FILE_SEKOLAH\WEB XII\absensi-hotel - Copy\resources\views/admin/layouts/app.blade.php ENDPATH**/ ?>